import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {ReactiveFormsModule} from '@angular/forms';
import { BaseAdminModule } from '@common/admin/base-admin.module';
import { ChipInputModule } from '@common/core/ui/chip-input/chip-input.module';
import { DriveSettingsComponent } from './settings/drive-settings/drive-settings.component';
import { MatProgressBarModule } from '@angular/material/progress-bar';
import { ConfirmModalModule } from '@common/core/ui/confirm-modal/confirm-modal.module';

@NgModule({
    imports: [
        CommonModule,
        ReactiveFormsModule,
        BaseAdminModule,
        ConfirmModalModule,

        // material
        ChipInputModule,
        MatProgressBarModule,
    ],
    declarations: [
        DriveSettingsComponent,
    ],
})
export class AppAdminModule {
}
